<?php
/**
* LibAjax
* An open source, LGPL AJAX/XMLHTTPRequest (Asynchronous JavaScript and XML) class for PHP.
* <br /> ------ <br />
* This library is free software; you can redistribute it and/or <br />
* (modify it under the terms of the GNU Lesser General Public <br />
* License as published by the Free Software Foundation; either <br />
* version 2.1 of the License, or (at your option) any later version. <br />
* This library is distributed in the hope that it will be useful, <br />
* but WITHOUT ANY WARRANTY; without even the implied warranty of <br />
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU <br />
* Lesser General Public License for more details. <br /> 
* You should have received a copy of the GNU Lesser General Public <br />
* License along with this library; if not, write to the Free Software  <br />
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA <br />
* <br /> ------ <br />
* @copyright 2005 htpt://ominousminds.com
* @version 1.0.0a
* @author Justin Shreve <justin.shreve@gmail.com>
* @link http://ominousminds Ominous Minds
* @package LibAjax
*/

/**
* AJAX
* The class to wrap all the lib's functions together.
*/
class ajax {

	/**
	* Export
	* Tells which functions to export and allow use of in JavaScript.
	*/
	var $export = array();
	
	/**
	* URL
	* Act's as a wrapper for $_SERVER['REQUEST_URI'].
	* @see ajax::ajax()
	*/
	var $url = "";

	/**
	* Mode
	* Tells which mode we are using to send data. <br />
	* GET Should be used to view data, and POST should be used to send long strings of data <br />
	* or to edit or change data.
	* @link http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html RFC Standard
	*/
	var $mode;

	/**
	* Function
	* Tells which function to send to the javascript functions from PHP.
	*/
	var $func;
	
	/**
	* Arguments
	* The list of the arguments to send to the javascript functions, from PHP.
	*/
	var $args = array();
	
	/**
	* Javascript.
	* The string that holds all the javascript to print out.
	* @see ajax::output()
	*/
	var $return_javascript;
	
	/**
	* AJAX
	* Sets the URL value to take on $_SERVER['REQUEST_URI'];
	* @see ajax::$url
	*/
	function ajax()
	{
    	$this->url = $_SERVER['REQUEST_URI'];	
	}
	
	/**
	* Client Request
	* Sets the variables such as func and args from the get or post methods. <br />
	* and then calls back to set the values.
	* @see ajax::$func
	* @see ajax::$args
	*/
	function client_request()
	{
		// Are we using POST or GET methods?

		if(!empty($_GET['libajax_function']))
		{
	
			$this->func = $_GET['libajax_function'];

			if(!empty($_GET['libajax_args']))
			{
				$this->args = $_GET['libajax_args'];
			}

		}

		if(!empty($_POST['libajax_function'])) 
		{

			$this->func = $_POST['libajax_function'];

			if(!empty($_POST['libajax_args']))
			{
				$this->args = $_POST['libajax_args'];
			}
		}
			
			@call_user_func_array($this->func, $this->args);
	}

	/**
	* JAVASCRIPT
	* Loads all the javascript side of things into a string for later. <br />
	* I used a ob and heredoc work around due to the sheer ammount of data that had to be passed.
	* @return string The libajax_init and libajax_call functions to act as a wrapper for XMLHttpRequest.
	*/
	function javascript() {
		
	ob_start();
	print <<<LIBAJAX
function libajax_init() {
	// Ominousminds.com
	// Justin Shreve
	// http://libajax.sf.net
}

function libajax_call(name, args)
{
	var mode = "{$this->mode}";
	var url = "{$this->url}";
	
	if (window.XMLHttpRequest) { var ajax = new XMLHttpRequest(); }
	else if (window.ActiveXObject) { var ajax = new ActiveXObject("Microsoft.XMLHTTP") }
	
	if (mode == "GET")
	{
		if (url.indexOf("?") == -1) { url = url + "?"; }
		else { url = url + "&"; }
		url = url + "libajax_function=" + escape(name);
	 	for ( var i = 0; i < args.length-1; i++) { url = url + "&libajax_args[]=" + escape(args[i]); var data = null; }
	}

	else
	{
		var data = "libajax_function=" + escape(name);
		for ( var i = 0; i < args.length-1; i++) { data = data + "&libajax_args[]=" + escape(args[i]); }
	}
        
	ajax.open(mode, url, true);
	if(mode == "POST") { ajax.setRequestHeader("Content-type","application/x-www-form-urlencoded"); }
	
	ajax.onreadystatechange = function() { 
	
		if (ajax.readyState == 4)  
		{
			work = ajax.responseText.indexOf("\\n");
			ndata = ajax.responseText.substring(0, work);
			args[args.length-1](ndata);
		}
		
	}

	ajax.send(data);
}

LIBAJAX;

	$this->return_javascript = ob_get_contents();
	ob_end_clean();
	}
	
	/**
	* Create Function
	* Creates the wrapper function to call to libajax_call and to send the arguments and function name. <br />
	* The ob and heredoc goes for here as well, though it's not as much data.
	* @param $name string The name of the function to emulate.
	* @param $arguments mixed The arguments to emulate with the function name.
	*/
	
	function create_jsfunction($name, $arguments)
	{
		ob_start();	
		print <<<LIBAJAX

function ajax_{$name}()
{
	libajax_call("{$name}", ajax_{$name}.arguments);
}	
LIBAJAX;
		
		$html = ob_get_contents();
		ob_end_clean();
		$this->return_javascript = $this->return_javascript . $html;
	}
	
	/** 
	* Output
	* This function should be called in a javascript tag, or a file acting as a js file using the php header function, <br />
	* as it will call to create_jsfunction, and the javascript function, to generate a string to return, which holds every <br />
	* bit of the javascript side of things. 
	* @return string All the javascript to be used by the script.
	*/
	function output()
	{
		$this->javascript();
		
		foreach ($this->export as $function) {
			$final .= $this->create_jsfunction($function, $this->args);
		}
		
		$this->return_javascript = $this->return_javascript . $final;
		
		print $this->return_javascript;
	}
}
?>